library(readxl)
library(tidyverse)
library(GGally)
library(dplyr)
library(tidyr)
library(plotly)

cheese = read_excel(
  'DataSets.xlsx',
  sheet = 'correlation_regression',
  range = 'B14:F44'
)

summary(cheese)

# head excluding the first column
head(cheese[-1])

# scatter plot
plot(cheese[-1])
ggpairs(cheese[-1]) + theme_test()

# ggcorrplot
library(ggcorrplot)

cor_mat = cor(cheese[-1])
p_mat = cor_pmat(cheese[-1])
cor_mat
p_mat

ggcorrplot(cor_mat)

ggcorrplot(corr = cor_mat, p.mat = p_mat,
           method = 'square',
           type = 'lower', insig = 'pch', 
           ggtheme = ggplot2::theme_test)

# correlation test
cor(cheese$Taste, cheese$Acetic)
cor.test(cheese$Taste, cheese$Acetic)

# Pearson's product moment correlation: data must be normally distributed. If not met, or the data is of 'rank', or 'ordinal' types, we should go for Spearman Rank correlation test.

cor.test(cheese$Taste, cheese$Acetic,
         method = 'spearman')


